load('Figure1S1_Data.mat')
%% control size
figure;
semilogy(TimeAxis_1,Cnt_size,'o','markersize',18,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
hold on
CntMeanSize=mean(Cnt_size);
line([4 24],[CntMeanSize CntMeanSize],'color',[0 83 125]./255,'linewidth',4,'linestyle',':')
line([24 65],[CntMeanSize CntMeanSize],'color',[0 83 125]./255,'linewidth',4)
set(gca,'fontsize',25)
axis([-10 75 0.6 2])
set(gca,'ytick',[0.7 1 1.5 2],'xtick',[]);

%% control Proliferation rates
CellNum_Cnt1=CellNum_Cnt1./CellNum_Cnt1(1);
figure;
semilogy(TimeAxis_2([1 3:11]),CellNum_Cnt1([1 3:11]),'o','markersize',18,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
hold on
[ControlCount0,gof0]=fit(TimeAxis_2(1:11),log(CellNum_Cnt1(1:11)),'poly1','exclude',2);
[ControlCount1,gof1]=fit(TimeAxis_2(1:5),log(CellNum_Cnt1(1:5)),'poly1','exclude',2,'weight',[1 1 1 1 4]);
[ControlCount2,gof2]=fit(TimeAxis_2(5:11),log(CellNum_Cnt1(5:11)),'poly1','weight',[4 1 1 1 1 1 1]);
E_alpha_Cntr_0=gof0.sse/diff(TimeAxis_2([1 5]));
E_alpha_Cntr_1=gof1.sse/diff(TimeAxis_2([1 5]));
E_alpha_Cntr_2=gof2.sse/diff(TimeAxis_2([5 11]));
plot(-5:1:24,exp(ControlCount0(-5:1:24)),'color',[0 83 125]./255,'linewidth',4,'linestyle',':');
plot(25:1:70,exp(ControlCount0(25:1:70)),'color',[0 83 125]./255,'linewidth',4)
% ylim([500 4700]); 
axis([-10 75 0.8 7])
% patch([-10 24 24 -10],[500 500 4700 4700],[78 166 194]./255,'facealpha',0.15,'edgecolor','none');
% patch([24 75 75 24],[500 500 4700 4700],[0 83 125]./255,'facealpha',0.15,'edgecolor','none');
set(gca,'fontsize',28,'ytick',1:2:7);%,'yticklabel',1:4)
%% 7uM Rapamycin Proliferation rates
% figure(2);clf;
% semilogy(TimeAxis_2([1 3:11]),CellNum_7uM_Rap([1 3:11]),'o','markersize',15,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
% hold on
% ylim([500 4700])
% xlim([-10 75])
[RapamycinCountFit1,gofR1]=fit(TimeAxis_2(1:5),log(CellNum_7uM_Rap(1:5)),'poly1','exclude',2,'weight',[1 1 1 1 4]);
[RapamycinCountFit2,gofR2]=fit(TimeAxis_2(5:11),log(CellNum_7uM_Rap(5:11)),'poly1','weight',[4 1 1 1 1 1 1]);
E_alpha_7uM_Rap_1=gofR1.sse/diff(TimeAxis_2([1 5]));
E_alpha_7uM_Rap_2=gofR2.sse/diff(TimeAxis_2([5 11]));
% plot(-5:1:17,exp(RapamycinCountFit1(-5:1:17)),'color',[186 180 216]./255,'linewidth',4)
% plot(18:1:70,exp(RapamycinCountFit2(18:1:70)),'color',[88 68 130]./255,'linewidth',4)
% set(gca,'fontsize',22,'ytick',1e3:1e3:4e3,'yticklabel',1:4)
%% 7uM rapamycin1 size
% figure;
% semilogy(TimeAxis_1,Normalized_Rapamycin_Size_7uM,'o','markersize',15,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
% hold on
[RapamycinSize1]=fit(TimeAxis_1(1:4),Normalized_Rapamycin_Size_7uM(1:4)','poly1');
RapamycinSize2=mean(Normalized_Rapamycin_Size_7uM(4:8));
% plot(2:1:24,RapamycinSize1(2:1:24),'color',[186 180 216]./255,'linewidth',4)
% line([24 65],[RapamycinSize2 RapamycinSize2],'color',[88 68 130]./255,'linewidth',4)
% set(gca,'fontsize',22)
% axis([-10 75 0.6 2])
% set(gca,'ytick',[0.7 1 1.5 2],'xtick',[]);

%% 0.07uM Rapamycin Proliferation rates
[ControlCount0]=fit(TimeAxis_2(1:11),log(CellNum_Cnt1(1:11)),'poly1','exclude',2);
[ControlCount1]=fit(TimeAxis_2(1:5),log(CellNum_Cnt1(1:5)),'poly1','weight',[1 1 1 1 4]);
[ControlCount2]=fit(TimeAxis_2(5:11),log(CellNum_Cnt1(5:11)),'poly1','weight',[4 1 1 1 1 1 1]);

CellNum_07uM_Rap=CellNum_07uM_Rap./CellNum_07uM_Rap(1);
figure;
semilogy(TimeAxis_2([1 3:9]),CellNum_07uM_Rap([1 3:9]),'o','markersize',18,'markerfacecolor',[0.7 0.7 0.7],'markeredgecolor','none')
hold on
% ylim([500 4700])
axis([-10 75 0.8 7])
[RapamycinCountFit0]=fit(TimeAxis_2(1:3),log(CellNum_07uM_Rap(1:3)),'poly1');
[RapamycinCountFit1,gof1]=fit(TimeAxis_2(1:5),log(CellNum_07uM_Rap(1:5)),'poly1','weight',[1 1 1 1 4],'exclude',2);
[RapamycinCountFit2,gof2]=fit(TimeAxis_2(5:8),log(CellNum_07uM_Rap(5:8)),'poly1','weight',[4 1 1 1]);
E_alpha_07uM_Rap_1=gof1.sse/diff(TimeAxis_2([1 5]));
E_alpha_07uM_Rap_2=gof2.sse/diff(TimeAxis_2([5 8]));
plot(-5:1:18,exp(RapamycinCountFit1(-5:1:18)),'color',[88 68 130]./255,'linewidth',4,'linestyle',':')
plot(18:1:50,exp(RapamycinCountFit2(18:1:50)),'color',[88 68 130]./255,'linewidth',4)
set(gca,'fontsize',28,'ytick',1:2:7);%,'yticklabel',1:4)
%% 0.07uM rapamycin1 size
[DPC_CellCount_Cnt]=fit(TimeAxis_2,log(CellNum_Cnt1),'poly1');
[DPC_CellCount_Rapamycin_0]=fit(TimeAxis_2(2:11),log(CellNum_07uM_Rap(2:11)),'poly3');

figure;
semilogy(TimeAxis_1,Normalized_Rapamycin_Size_07uM,'o','markersize',18,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
hold on
[RapamycinSize1]=fit(TimeAxis_1(1:5),Normalized_Rapamycin_Size_07uM(1:5)','poly1');
RapamycinSize2=mean(Normalized_Rapamycin_Size_07uM(5:8));
plot(2:1:40,RapamycinSize1(2:1:40),'color',[88 68 130]./255,'linewidth',4,'linestyle',':')
line([40 65],[RapamycinSize2 RapamycinSize2],'color',[88 68 130]./255,'linewidth',4)
set(gca,'fontsize',25)
axis([-10 75 0.6 2])
set(gca,'ytick',[0.7 1 1.5 2],'xtick',[]);

%% 39 nM SN032 proliferation rates
% figure(4);clf;
% semilogy(TimeAxis_2([1:3 5:11]),CellNum_39nM_SN032([1:3 5:11]),'o','markersize',15,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
% hold on
% ylim([500 4700])
% xlim([-10 80])
[DrugCount0]=fit(TimeAxis_2(2:11),log(CellNum_39nM_SN032(2:11)),'poly1');
[DrugCount1,gof1]=fit(TimeAxis_2(2:6),log(CellNum_39nM_SN032(2:6)),'poly1');
[DrugCount2,gof2]=fit(TimeAxis_2(6:11),log(CellNum_39nM_SN032(6:11)),'poly1');
E_alpha_39uM_SN_1=gof1.sse/diff(TimeAxis_2([2 6]));
E_alpha_39uM_SN_2=gof2.sse/diff(TimeAxis_2([6 11]));
% plot(-5:1:28,exp(DrugCount0(-5:1:28)),'color',[237 174 174]./255,'linewidth',4)
% plot(30:1:70,exp(DrugCount0(30:1:70)),'color',[194 87 87]./255,'linewidth',4)
% set(gca,'fontsize',22,'ytick',1e3:1e3:4e3,'yticklabel',1:4);
% ylim([500 4700]); xlim([-10 75])
%% 39 nM SN032 size 
[DPC_CellCount_Cnt]=fit(TimeAxis_2,log(CellNum_Cnt1),'poly1');
[DPC_CellCount_Drug_0]=fit(TimeAxis_2(2:11),log(CellNum_39nM_SN032(2:11)),'poly3');
[SizeDrug1]=fit(TimeAxis_1([1:5]),Normalized_SN032_39nM_Size([1:5])','poly1');
[SizeDrug2]=mean(Normalized_SN032_39nM_Size([5:8]));
[SizeDrug3]=mean(Normalized_SN032_39nM_Size([6:8]));
[SizeDrug0]=fit(TimeAxis_1([1:8]),Normalized_SN032_39nM_Size([1:8])','exp2');
% figure(5);clf
% semilogy(TimeAxis_1,Normalized_SN032_39nM_Size,'o','markersize',15,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
% [SizeDrug1]=fit(TimeAxis_1([1:5]),Normalized_SN032_39nM_Size([1:5])','poly1');
% [SizeDrug2]=mean(Normalized_SN032_39nM_Size([5:8]));
% [SizeDrug3]=mean(Normalized_SN032_39nM_Size([6:8]));
% [SizeDrug0]=fit(TimeAxis_1([1:8]),Normalized_SN032_39nM_Size([1:8])','exp2');
% hold on
% plot(5:1:33,SizeDrug1(5:1:33),'color',[237 174 174]./255,'linewidth',4)
% line([34 65],[SizeDrug2 SizeDrug2],'color',[194 87 87]./255,'linewidth',4)
% axis([-10 75 0.6 2])
% set(gca,'ytick',[0.7 1 1.5 2],'xtick',[]);
% set(gca,'fontsize',22)
% % patch([-10 28 28 -10],[0.6 0.6 2 2],[237 174 174]./255,'facealpha',0.15,'edgecolor','none');
% % patch([28 75 75 28],[0.6 0.6 2 2],[0 83 125]./255,'facealpha',0.15,'edgecolor','none');

%% 19 nM SN032 proliferation rates
CellNum_19nM_SN032=CellNum_19nM_SN032./CellNum_19nM_SN032(1);
figure;
semilogy(TimeAxis_2([1:3 5:11]),CellNum_19nM_SN032([1:3 5:11]),'o','markersize',18,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
hold on
% ylim([500 4700])
axis([-10 80 0.8 7])
[DrugCount0]=fit(TimeAxis_2(2:11),log(CellNum_19nM_SN032(2:11)),'poly1');
[DrugCount1,gof1]=fit(TimeAxis_2(2:6),log(CellNum_19nM_SN032(2:6)),'poly1');
[DrugCount2,gof2]=fit(TimeAxis_2(6:11),log(CellNum_19nM_SN032(6:11)),'poly1');
[SecondContCount1]=fit(TimeAxis_2(1:9),log(CellNum_Cnt1(1:9)),'poly1','exclude',3);
[SecondContCount2]=fit(TimeAxis_2(1:9),log(CellNum_Cnt1(1:9)),'poly1','exclude',3);

plot(-5:1:28,exp(DrugCount0(-5:1:28)),'color',[194 87 87]./255,'linewidth',4,'linestyle',':')
plot(30:1:70,exp(DrugCount0(30:1:70)),'color',[194 87 87]./255,'linewidth',4)
set(gca,'fontsize',28,'ytick',1:2:7,'xtick',0:20:60);%1e3:1e3:4e3,'yticklabel',1:4);
% ylim([500 4700]); xlim([-10 75])

E_alpha_19uM_SN_1=gof0.sse/diff(TimeAxis_2([2 5]));
E_alpha_19uM_SN_2=gof0.sse/diff(TimeAxis_2([5 8]));


%% 19 nM SN032 size 

figure;clf;
semilogy(TimeAxis_1,Normalized_19nM_SN032_Size,'o','markersize',18,'markerfacecolor',[0.8 0.8 0.8],'markeredgecolor','none')
[SizeDrug1]=fit(TimeAxis_1([1:4]),Normalized_19nM_SN032_Size([1:4])','poly1');
[SizeDrug2]=mean(Normalized_19nM_SN032_Size([5:8]));
[SizeDrug3]=mean(Normalized_19nM_SN032_Size([6:8]));
[SizeDrug0]=fit(TimeAxis_1([1:8]),Normalized_19nM_SN032_Size([1:8])','exp2');

hold on;
semilogy(5:1:30,SizeDrug1(5:1:30),'color',[194 87 87]./255,'linewidth',4,'linestyle',':')
line([30 65],[SizeDrug2 SizeDrug2],'color',[194 87 87]./255,'linewidth',4)
axis([-10 75 0.6 2])
set(gca,'ytick',[0.7 1 1.5 2],'xtick',[]);
set(gca,'fontsize',25)


